/*********************************************************************
 *
 *      MCP19117 Standalone Flyback Firmware Example
 *      Revision 1.1
 *
 *********************************************************************
 * FileName:        main.c
 *
 * Processor:       MCP19117
 *
 * Complier:        MPLAB XC8
 *                  MPLAB IDE
 * Company:         Microchip Technology Inc.
 *
 * Software License Agreement
 *
 * Copyright  2016 released Microchip Technology Inc.  All rights reserved.
 *
 * Microchip licenses to you the right to use, modify, copy and distribute the
 * accompanying software only when embedded on a Microchip microcontroller or
 * digital signal controller that is integrated into your product or third party
 * product.
 *
 * If the accompanying software require your consent to the terms of Microchip's
 * click-wrap license agreement, then you should also refer to such license
 * agreement for additional information regarding your rights and obligations.
 * Your acceptance and/or use of this software constitutes your agreement to the
 * terms and conditions of this notice and applicable click-wrap license, if any.
 *
 * You agree that you are solely responsible for testing the code and determining
 * its suitability.  Microchip has no obligation to modify, test, certify, or
 * support the code.
 *
 * SOFTWARE AND DOCUMENTATION ARE PROVIDED ?AS IS? WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY, TITLE, NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.
 * IN NO EVENT SHALL MICROCHIP OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER
 * CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY,
 * OR OTHER LEGAL EQUITABLE THEORY FOR ANY DIRECT OR INDIRECT DAMAGES OR
 * EXPENSES INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT,
 * PUNITIVE OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY
 * THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER
 * SIMILAR COSTS
 **********************************************************************

 ********************************************************************/

#include <xc.h>
#include "main_header.h"    // Variables and Function Prototypes
#define _XTAL_FREQ 8000000

// CONFIG

#pragma config WDTE = OFF       // Watchdog Timer Enable bit (WDT disabled and can be enabled by SWDTEN bit of the WDTCON register)
#pragma config PWRTE = ON       // Power-up Timer Enable bit (PWRT disabled)
#pragma config MCLRE = OFF      // MCLR Pin Function Select bit (MCLR pin is MCLR function and weak internal pull-up is enabled)
#pragma config CP = OFF         // Code Protection bit (Program memory is not code protected)
#pragma config BOREN = OFF      // Brown-out Reset Enable bit (BOR disabled during sleep and enabled during operation)
#pragma config WRT = OFF        // Flash Program Memory Self Write Enable bits (Write protection off)

//#pragma CONFIG = 0x3FF7
extern volatile unsigned int ADRES @ 0x01C;
extern unsigned char N_itp = 1;
/***********************************************************/
/***********************************************************/
// MAIN
/***********************************************************/
/***********************************************************/
void main(void)
{
    unsigned char TEMP_BUFFER;

      // ---- Initial ---- //
reset:
    init_Calibration();       // Places factory calibration values into appropriate registers
    init_SFR();               // Initializes necessary registers with drivers OFF
    init_Periphrials();       // Initialize I2C communication Registers
    SSP_UPDATE = 0;           // Clear control flags
    PIR1        = 0x00;       // Clear All Flags
    PIR2        = 0x00;       // Clear All Flags
    PORTGPBbits.GPB1 = 1;     // Turn on LED indicator on board indicator  for efficiency test   gpb = 0
    OVF = 0;                  // Clear VO interrupt Routine flag
    N_itp = 1;                // No interruption

    while(1)                  // Main Forever
    {
        while(N_itp);         // Search event when interrupt happened
        if (SSP_UPDATE)
        {
            Update_Controller();   // Update Controller
        }

        if ((SSPSTATbits.P) || (SSPCON1bits.WCOL))
        {
            SSPCON1 = 0x00;
            TEMP_BUFFER = SSPBUF;
            SSPSTAT = 0x00;
            SSPCON2 = 0x00;
            SSPCON3 = 0x00;
            SSPCON1 = 0x36;
        }

          if(SSP_ENABLEbits.VOUOVLO_EN && OVF)       // Output Over Voltage Flag Set OVCONbits.OVEN &&
        {
            PE1 = PDRV_SDRV_OFF;
            OVF = 0;
            FLASH_3();
            FLASH_3();            // One Short One Long Flashing
            goto reset;
        }

        if(VINCONbits.OVLOEN && VINCONbits.OVLOOUT )  // Input Over Voltage Flag set
        {
            PE1 = PDRV_SDRV_OFF;
            while(VINCONbits.OVLOOUT)
            {
            FLASH_1();           // Long Flashing Routine
            }
        }
        if(VINCONbits.UVLOEN && VINCONbits.UVLOOUT )   // Input Under Voltage Flag set
        {
            PE1 = PDRV_SDRV_OFF;
            while(VINCONbits.UVLOOUT)
            {
            FLASH_2();          // Short Flashing Routine
            }
        }
        N_itp = 1;
    }

}

static void interrupt VEC_vidInterruptVector(void)
{
 if(PIR1bits.SSPIF)
    {
        PIR1bits.SSPIF= 0;           // Clear Flag
        IIC_Handler();               // Go to I2C Interrupt Routine
        SSPCON1bits.CKP = 1;
    } else
 if(PIR2bits.OVIF)                   // Detect VOUT OVLO Happened
    {
        PE1 = PDRV_SDRV_OFF;
        PIR2bits.OVIF = 0;
        OVF = 1;
    }else

 if(PIR2bits.OVLOIF);                // Detect VIN OVLO Happened
 {
     PIR2bits.OVLOIF = 0;
 }
 if(PIR2bits.UVLOIF);                // Detect VIN UNLO Happened
 {
     PIR2bits.UVLOIF = 0;
 }
 N_itp = 0;
}

void Update_Controller(void)
{

    SSP_UPDATE = 0;                 // Clear Update Flag
    PE1 = PDRV_SDRV_OFF;            // Turn Off all Drivers
    VINUVLO = SSP_VINUVLO;          // Set VINUVLO
    VINOVLO = SSP_VINOVLO;          // Set VINOVLO
    ADCON0  = SSP_ADCON0;           // Set AD
    ABECON =  SSP_ABECON;           // Set Analog channel
    VREFCON = 0x04 ;                // Output Regulation Soft start-up
    OVREFCON = SSP_OVREFCON  ;      // Over Voltage Protection Set
    DEADCON = SSP_DEADCON  ;        // Driver dead time set
    ICLEBCON = SSP_ICLEBCON;        // Leading Edge Blanking
    ICOACON = SSP_ICOACON;          // INPUT CURRENT OFFSET ADJUST
    SLPCRCON = SSP_SLPCRCON;        // Slop compensation
    unsigned int VREF1_TEMP = SSP_VREFCON1;  // Set VREFCON for soft start


    //*******************SFR Registers Update ********************//
    int *p0 , *p2 , *p3 , *p1 ;
    p0 = 0; p1 = 0; p2 = 0; p3 = 0;
    // UPDATE REG0
    if(SSP_REG_BANKbits.BANK0_EN == 1)               //REG0 Bank2 selected by GUI
    {
        p0 = (int *)SSP_REG_ADD0 + 0b10000000 ;
    }
    else
    {
        p0 = (int *)SSP_REG_ADD0;
    }
    *p0 = SSP_REG_DATA0;                             // Update REG value
    // UPDATE REG1
    if(SSP_REG_BANKbits.BANK1_EN == 1)               //REG1 Bank2 selected by GUI
    {
        p1 = (int *)SSP_REG_ADD1 + 0b10000000 ;
    }
    else
    {
        p1 = (int *)SSP_REG_ADD1;
    }
    *p1 = SSP_REG_DATA1;                             // Update REG value
    // UPDATE REG2
    if(SSP_REG_BANKbits.BANK2_EN == 1)               //REG2 Bank2 selected by GUI
    {
        p2 = (int *)SSP_REG_ADD2 + 0b10000000 ;
    }
    else
    {
        p2 = (int *)SSP_REG_ADD2;
    }
    *p2 = SSP_REG_DATA2;                             // Update REG value
    // UPDATE REG3
    if(SSP_REG_BANKbits.BANK3_EN == 1)               //REG3 Bank2 selected by GUI
    {
        p3 = (int *)SSP_REG_ADD3 + 0b10000000 ;
    }
    else
    {
        p3 = (int *)SSP_REG_ADD3;
    }
    *p3 = SSP_REG_DATA3;                             // Update REG value
   /************************************************************************/

    DESATCON = DESATCON_FF;                          // Operating Fixed Frequency
    if (!SSP_ENABLEbits.EN)
    {
          PE1 = PDRV_SDRV_OFF;
          ABECONbits.EADIS = 1;
          VREFCON = CMD_NO_CURRENT;
          T2CONbits.TMR2ON = 0;
          DESATCON = DESATCON_FF;
    }
    else
    {
       if (SSP_ENABLEbits.VINOVLO_EN)
       {
           VINCONbits.OVLOEN = 1;       // Enable VIN OVLO
           VINCONbits.OVLOINTP = 1;
           VINCONbits.OVLOINTN = 1;
       }
       else
       {
           VINCONbits.OVLOEN = 0;
           VINCONbits.OVLOINTP = 0;
           VINCONbits.OVLOINTN = 0;
       }

       if (SSP_ENABLEbits.VINUVLO_EN)
       {
           VINCONbits.UVLOEN = 1;       // Enable VIN UVLO
           VINCONbits.UVLOINTP = 1;
           VINCONbits.UVLOINTN = 1;
       }
       else
       {
           VINCONbits.UVLOEN = 0;
           VINCONbits.UVLOINTP = 0;
           VINCONbits.UVLOINTN = 0;
       }

       if (SSP_ENABLEbits.VOUOVLO_EN)    // Enable VOUT OVLO
       {
           OVCONbits.OVEN = 0;
           OVCONbits.OVINTP = 1;
           OVCONbits.OVINTN = 1;
           PIE2bits.OVIE = 1;
       }
       else
       {
           OVCONbits.OVEN = 0;
           OVCONbits.OVINTP = 0;
           OVCONbits.OVINTN = 0;
           PIE2bits.OVIE = 0;
       }


       PORTGPAbits.GPA3 = 0;               // Clear Both Switched
       PORTGPAbits.GPA1 = 0;
       if (SSP_REG_BANKbits.SWITCH_1)
       {
           PORTGPAbits.GPA3 = 1;
       }
       if (SSP_REG_BANKbits.SWITCH_2)
       {
           PORTGPAbits.GPA1 = 1;
       }

      ABECONbits.DRUVSEL = 0;   //DRUVLO  under lock at 2.7V

 /******************Zero Duty Cycle Soft Start For LED ********************/
//
       PR2 = REPO_PWM;           // Open loop reposition 200kHz Soft start Fixed Frequency
       PWMRL = 0x00;             // Duty Cycle Start from zero
       PWMRH = 0x00;
       T2CONbits.TMR2ON = 1;
       ABECONbits.EADIS = 0;

       PE1 = PDRV_ON;
       //PE1 = 0x00;
       while( PWMRL < REPO_DC)
       {
           PWMRL++;
           PWMRH++;
           _delay(200);
       }

       PR2 = SSP_PR2;
       PWMRL = SSP_PWMR;
       PWMRH = SSP_PWMR;

       if (!SSP_ENABLEbits.FF_QRn)        // OR Mode Select
       {
          DESATCON = DESATCON_QR;
       }

       while(VREFCON < VREF1_TEMP)
       {
           VREFCON =VREFCON +1;
           _delay(10);
       }

       OPTION_REGbits.PS = PS512uS;
       TMR0 = 0;
       INTCONbits.T0IF = 0;
       while(!INTCONbits.T0IF);   
       if (SSP_ENABLEbits.SYNC_ASYNCn)PE1bits.SDRVEN = 1;
          
   }
}

void FLASH_1(void)
{
    for(COUNT = 1; COUNT <= 2; COUNT++)
    {
        PORTGPBbits.GPB1 = 0;
        __delay_ms(100);
        PORTGPBbits.GPB1 = 1;
        __delay_ms(100);
    }

}

void FLASH_2(void)
{
    for(COUNT = 1; COUNT <= 2; COUNT++)
    {
        PORTGPBbits.GPB1 = 0;
        __delay_ms(30);
        PORTGPBbits.GPB1 = 1;
        __delay_ms(30);
    }

}

void FLASH_3(void)
{
    for(COUNT = 1; COUNT <= 2; COUNT++)
    {
        __delay_ms(300);
        PORTGPBbits.GPB1 = 0;
        __delay_ms(300);
        PORTGPBbits.GPB1 = 1;
        __delay_ms(150);
        PORTGPBbits.GPB1 = 0;
        __delay_ms(300);
        PORTGPBbits.GPB1 = 1;
    }

}